#!/bin/sh

TP_NETWORK_CONF_RESULT_OK="DTAS[TUI]@{OK}"
TP_NETWORK_CONF_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_NETWORK_CONF_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_NETWORK_CONF_RESULT_CODE=""

TP_NETWORK_CONF_RESULT_MSG=""

TP_NETWORK_CONF_RESULT_IP=""
TP_NETWORK_CONF_RESULT_NETMASK=""
TP_NETWORK_CONF_RESULT_GATEWAY=""
TP_NETWORK_CONF_RESULT_DNS=""
TP_NETWORK_CONF_RESULT_DNS2=""

tp_network_conf() {
	#debug_print "${0}" "${LINENO}" 'in function "tp_network_conf"'
	
    local title="${1}"
    local text="${2}"
    local label_ok="${3}"
    local label_cancel="${4}"
    local ip="${5}"
    local netmask="${6}"
    local gateway="${7}"
    local ipv6="${8}"
    local ipv6_prefix_length="${9}"
    local ipv6_gateway="${10}"

    local dns="${11}"
    local dns2="${12}"
    local dns3="${13}"
    
    dprint "DEBUG" "Current IP settings: ip(${ip}), netmask(${netmask}), \
 gateway(${gateway}), ipv6(${ipv6}), prefix_length(${ipv6_prefix_length}), \
 ipv6_gateway(${ipv6_gateway}), dns(${dns}), dns2(${dns2}), dns3(${dns3})"

    # Hide IPV6 temporily
    #"${STRING_IPV6_ADDRESS}"           5   0 "${ipv6}"               5  26 40 39 0 \
    #"${STRING_IPV6_PREFIX_LENGTH}"     6   0 "${ipv6_prefix_length}" 6  26 40 3  0 \
    #"${STRING_IPV6_GATEWAY}"	   7   0 "${ipv6_gateway}"       7  26 40 39 0 \
    
    exec 3>&1
    local ret=`dialog \
        --backtitle    "${CONS_BACK_TITLE}" \
        --title        "${title}" \
        --ok-label     "${label_ok}" \
        --cancel-label "${label_cancel}" \
        --mixedform    "${text}" \
                       "${CONS_BOX_HEIGHT}" \
                       "${CONS_BOX_WIDTH}" \
                       0 \
        "${STRING_IP_ADDRESS}"             1   0 "${ip}"                 1  26 40 15 0 \
        "${STRING_NETMASK}"                2   0 "${netmask}"            2  26 40 15 0 \
        "${STRING_GATEWAY}"	           3   0 "${gateway}"            3  26 40 15 0 \
        "${STRING_DNS}"		           5   0 "${dns}"                5  26 40 39 0 \
        "${STRING_DNS2}"	           6   0 "${dns2}"               6  26 40 39 0 \
        "${STRING_DNS3}"                   7   0 "${dns3}"               7  26 40 39 0 \
        2>&1 1>&3; \
        case "${?}" in \
            1|255) echo "${TP_NETWORK_CONF_RESULT_CANCEL}" ;; \
        esac`
    exec 3>&-

    
    case "${ret}" in
        "${TP_NETWORK_CONF_RESULT_CANCEL}" )
            TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_CANCEL}"
            TP_NETWORK_CONF_RESULT_MSG=""
            return
            ;;
    esac

    #debug_print "${0}" "${LINENO}" "ret: ${ret}"
    local input_ip=`echo "${ret}" | sed -n '1p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}'`
    dprint "DEBUG" "get ip_address from dialog: ${input_ip}"
		
    local input_netmask=`echo "${ret}" | sed -n '2p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}'`
    dprint "DEBUG" "get netmask from dialog: ${input_netmask}"
		
    local input_gateway=`echo "${ret}" | sed -n '3p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}'`
    dprint "DEBUG" "get gateway from dialog: ${input_gateway}"

    #local input_ipv6=`echo "${ret}" | sed -n '4p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}' | tr '[a-z]' '[A-Z]'`
    #dprint "DEBUG" "get ipv6_address from dialog: ${input_ipv6}"
		
    #local input_ipv6_prefix_length=`echo "${ret}" | sed -n '5p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}'`
    #dprint "DEBUG"  "get ipv6_prefix_length from dialog: ${input_ipv6_prefix_length}"
		
    #local input_ipv6_gateway=`echo "${ret}" | sed -n '6p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}' | tr '[a-z]' '[A-Z]'`
    #dprint "DEBUG"  "get ipv6_gateway from dialog: ${input_ipv6_gateway}"

    local input_dns=`echo "${ret}" | sed -n '4p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}' | tr '[a-z]' '[A-Z]'`
    dprint "DEBUG"  "get dns from dialog: ${input_dns}"

    local input_dns2=`echo "${ret}" | sed -n '5p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}' | tr '[a-z]' '[A-Z]'`
    dprint "DEBUG"  "get dns2 from dialog: ${input_dns2}"
		
    local input_dns3=`echo "${ret}" | sed -n '6p' | sed -e "s/^[ ]*//" | sed -e "s/[ ]*$//" | awk -F '#012' '{print $1}' | tr '[a-z]' '[A-Z]'`	
    dprint "DEBUG"  "get dns3 from dialog: ${input_dns3}"
		

    TP_NETWORK_CONF_RESULT_IP="${input_ip}"
    TP_NETWORK_CONF_RESULT_NETMASK="${input_netmask}"
    TP_NETWORK_CONF_RESULT_GATEWAY="${input_gateway}"
    TP_NETWORK_CONF_RESULT_IPV6="${ipv6}"
    TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH="${ipv6_prefix_length}"
    TP_NETWORK_CONF_RESULT_IPV6_GATEWAY="${ipv6_gateway}"
    TP_NETWORK_CONF_RESULT_DNS="${input_dns}"
    TP_NETWORK_CONF_RESULT_DNS2="${input_dns2}"
    TP_NETWORK_CONF_RESULT_DNS3="${input_dns3}"

    dprint "DEBUG" "Check user input"
    # Temporarily don't allow pure IPv6 setting, because U-Sandbox only support dual stack.
    if [ "${input_ip}" = "" ]; then
        dprint "ERROR"  "invalid IP: ${input_ip}"
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IP}"
        return
    fi

    if [ "${input_ip}" = "" ] && [ "${ipv6}" = "" ];then
        dprint "ERROR" "Both IPv4 and IPv6 Address fields cannot be empty"
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_EMPTY_IP_AND_IPV6}"
        return
    fi

  if [ "${input_ip}" = "" ]; then
    if [ "${input_netmask}" != "" ] || [ "${input_gateway}" != "" ]; then
        dprint "ERROR"  "${TP_NETWORK_CONF_ERROR_IP_EMPTY}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_IP_EMPTY}"
        return
    fi
  else
    if ! $(is_ip_address_valid "${input_ip}") ; then
        dprint "ERROR" "invalid IP: ${input_ip}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IP}"
        return
    fi

    if ! $(is_netmask_valid "${input_netmask}") ; then
        dprint "ERROR"  "invalid netmask: ${input_netmask}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_NETMASK}"
        return
    fi

    if ! $(is_gateway_valid "${input_ip}" "${input_netmask}" "${input_gateway}") ; then
        dprint "ERROR"  "invalid gateway: ${input_gateway}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_GATEWAY}"
        return
    fi

  fi
    
  if [ "${ipv6}" = "" ]; then
    if [ "${ipv6_prefix_length}" != "" ] || [ "${ipv6_gateway}" != "" ]; then
	dprint "ERROR"  "${TP_NETWORK_CONF_ERROR_IPV6_EMPTY}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_IPV6_EMPTY}"
        return
    fi
  else
    if ! $(is_ipv6_address_valid "${ipv6}") ; then
	dprint "ERROR"  "invalid IPv6: ${ipv6}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6}"
        return
    fi

    if ! $(is_ipv6_prefix_length_valid "${ipv6_prefix_length}") ; then
        dprint "ERROR"  "invalid IPv6 prefix length: ${ipv6_prefix_length}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_PREFIX_LENGTH}"
        return
    fi

    #local ipv6_link_local=$(/sbin/ifconfig eth0 | grep 'inet6 addr:' | grep 'Scope:Link' | awk '{print $3}' | awk -F'/' '{print $1}' | tr '[a-z]' '[A-Z]')
    #if [ "${ipv6_link_local}" == "" ]; then
    #    local mac_addr=$(/sbin/ifconfig eth0 | /bin/grep "HWaddr" | awk '{print $5}')
    #    if [ "${mac_addr}" != "" ]; then
    #        ipv6_link_local=$(/usr/bin/ipv6calc --action prefixmac2ipv6 --in prefix+mac --out ipv6addr fe80:: ${mac_addr} | tr '[a-z]' '[A-Z]')
    #    fi
    #fi
    #if [ "${input_ipv6}" = "${ipv6_link_local}" ]; then
    local upcase=$(echo ${ipv6:0:5} | tr '[a-z]' '[A-Z]')
    if [ "${upcase}" = "FE80:" ]; then
     # if input IPv6 address is link local address, gateway and DNS can be empty
     if [ "${ipv6_gateway}" != "" ]; then
      if ! $(is_ipv6_address_valid "${ipv6_gateway}") ; then
        dprint "ERROR"  "invalid IPv6 gateway: ${ipv6_gateway}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_GATEWAY}"
        return
      fi
     fi
    else
      if ! $(is_ipv6_address_valid "${ipv6_gateway}") ; then
        dprint "ERROR"  "invalid IPv6 gateway: ${ipv6_gateway}"
        
        TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
        TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_GATEWAY}"
        return
      fi
    fi
  fi

   if [ "${input_dns}" != "" ]; then
        if [ "${ipv6}" != "" ]; then
            # IPv6, DNS could be either v4 or v6
            if ! $(is_ip_address_valid "${input_dns}") &&  ! $(is_ipv6_address_valid "${input_dns}") ; then
                dprint "ERROR" "Invalid dns1 (v4 or v6): ${input_dns}"
                TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
                TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS_V6}"
                return
            fi
        else
            if ! $(is_ip_address_valid "${input_dns}") ; then
                dprint "ERROR" "Invalid dns1: ${input_dns}"
                TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
                TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS}"
                return
            fi
        fi
    fi

    if [ "${input_dns2}" != "" ]; then
        if [ "${ipv6}" != "" ]; then
            # IPv6, DNS could be either v4 or v6
            if ! $(is_ip_address_valid "${input_dns2}") &&  ! $(is_ipv6_address_valid "${input_dns2}") ; then
                dprint "ERROR" "Invalid dns2 (v4 or v6): ${input_dns2}"
                TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
                TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS2_V6}"
                return
            fi
        else
            if ! $(is_ip_address_valid "${input_dns2}") ; then
                dprint "ERROR" "Invalid dns1: ${input_dns2}"
                TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
                TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS2}"
                return
            fi
        fi
    fi

    if [ "${input_dns3}" != "" ]; then
        if [ "${ipv6}" != "" ]; then
            # IPv6, DNS could be either v4 or v6
            if ! $(is_ip_address_valid "${input_dns3}") &&  ! $(is_ipv6_address_valid "${input_dns3}") ; then
                dprint "ERROR" "Invalid dns3 (v4 or v6): ${input_dns3}"
                TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
                TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS3_V6}"
                return
            fi
        else
            if ! $(is_ip_address_valid "${input_dns3}") ; then
                dprint "ERROR" "Invalid dns1: ${input_dns3}"
                TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_ERROR}"
                TP_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS3}"
                return
            fi
        fi
    fi


    dprint "DEBUG" "Check user input successfully"
    TP_NETWORK_CONF_RESULT_CODE="${TP_NETWORK_CONF_RESULT_OK}"
    TP_NETWORK_CONF_RESULT_MSG=""
    #save audit log
    # save_audit_log "all.systemEvents.textui.networksetting"
}
